#!/bin/sh
########################################################################
#
# Name:         	/replication/client_ls-n.sh
# Description:  	Get the "ls -n" on the remote system.
#               	This MUST be run as replid (See client_ls-n.c).  Call this 
#		shell by using the compiled output of client_ls-n.c Permissions
#		should be 500 and owned by root.
#               	Called from replication_server.sh
# Input:		$1 = Directory to perform the "ls -an" on.
#               	$2 = Name of the machine to do the "ls -an" on.
# Output:       	The output of ls -an for the passed in directory
# Author:      	Jim McKinstry 
#
#########################################################################


TO_ID="replid"


DIRECTORY=$1
TO_NODE=$2

remsh ${TO_NODE} -l ${TO_ID} -n /replication/ls-an_client ${DIRECTORY}

exit
