ࡱ                >  	               #          $          "   ܥh c	    e              )  B                  &                                   8  j    8  j   j8      j8      j8      j8      j8     8      8      8      8      8      8  
   8  (   8      ?A  1   9      9      9      9      9      9      9      9      ]?     _?      _?      _?     y?     M@     !A     pA  X   A  >   ?A                      j8      9            9      9                      9      9      ?A      >      j8      j8      9                      9      >      >      >      9    j8      9      j8      9      ]?              `8`~8      8  6   j8      j8      j8      j8      9      ]?      >  q   >                                                                                            #!/bin/sh
########################################################################
#
# Name: 	/replication/replication_server.sh
# Description:  	Replicate files from one machine to another.  This is run
#		from cron.
#		This shell calls:
#		check_ftp - checks if files were ftp'd OK
#		client_ls-n - does a "ls -n" on the remote machine
#		process_cpio_file - calls the shell on the client to process
#		the files to be copied and removed
#
# Input:        	$1 = Name of file that contains a list of directories to be replicated (in /replication/data)
#               	$2 = Name of the remote machine (see .rhosts for replid)
# Output:       	Log file: /replication/log/`basename $1`.log
# Author:	Jim McKinstry
#
#########################################################################

# Set up some variables
REPL_DIR="/replication/"
TO_NODE=$2
LIST_OF_DIRECTORIES=$1
TO_ID="replid"
TO_PASSWD="FaKePaSa"
LOG_FILE=/replication/log/`basename ${LIST_OF_DIRECTORIES}`.log
COPY_FTP_ERROR="Files were not copied from `uname` to ${TO_NODE} due to an FTP error. \ Check ${LOG_FILE} on `uname` for more details."
REMOVE_FTP_ERROR="Files were not copied from `uname` to ${TO_NODE} due to an FTP error. \ Check ${LOG_FILE} on `uname` for more details."

##########################################################################
## Log the time we started and the file that we are processing
##########################################################################
echo `date`: Starting file replication from `uname` to ${TO_NODE}. >> ${LOG_FILE}
echo >> ${LOG_FILE}
echo Replicating the directories listed in ${LIST_OF_DIRECTORIES} >> ${LOG_FILE}
echo >> ${LOG_FILE}

if [ ! -f ${LIST_OF_DIRECTORIES} ]     	# if an invalid file was passed in
then					# Then exit
  echo ${LIST_OF_DIRECTORIES} is not a valid input! ABORTING replication! >> ${LOG_FILE}
  exit 1
fi

NODE_TEST=`grep -cw ${TO_NODE} /etc/hosts`

if [ ${NODE_TEST} -eq 0 ]     		# If an invalid hostname was entered
then					# then exit
  echo $2 is not a valid host! ABORTING replication! >> ${LOG_FILE}
  exit 1
fi					# end of If invalid hostname
 
# get the list of directories to be replicated
REPLICATED_DIRECTORIES_LIST=`cat ${LIST_OF_DIRECTORIES}`  

##########################################################################
##  For each DIRECTORY listed in the file that was passed in as $1: get
##  the "ls -na" for the local and remote machines and sort the output 
##  ("comm" needs two sorted files to work correctly).  Do a
##  "comm -23 LOCAL_LS-N REMOTE_LS-N" to get the list of files that are NOT
##  on the remote machine (by using "ls -n" and doing the "comm", we are
##  comparing permissions, # of links, owner, group, size and mod time). These 
##  files will be copied onto the REMOTE machine.  CPIO/gzip the list of files.
##  Convert the "ls -an" for the LOCAL and REMOTE machines to "ls" format.
##  (this keeps us from doing another "ls" across the network).  Do a 
##  "comm -13 LOCAL_LS REMOTE_LS" to get a list of files that 
##  are on the REMOTE machine and not on the LOCAL machine.  These files will 
##  be removed from the REMOTE machine.  If there were files to be copied then 
##  FTP the CPIO/GZIPd files to the REMOTE machine.  If there were files to be 
##  removed then FTP the list to the remote system.  If there were files to be 
##  copied or removed then call a script that processes the files on the remote 
##  machine.  The remote machine will un-cpio/gunzip the files to be copied 
##  and will remove each file that was in the list of files to be removed.
##
##########################################################################

for DIRECTORY in ${REPLICATED_DIRECTORIES_LIST}  # Process each directory
do
  echo Processing: ${DIRECTORY} >> ${LOG_FILE}   	# log the DIR being replicated
 
# If the directory to be replicated does not exist then skip it
  if [ ! -d ${DIRECTORY} ]
  then
   echo ${DIRECTORY} does not exist and is being skipped! >> ${LOG_FILE}
   echo  >> ${LOG_FILE}
   continue
  fi

# define some temporary files.  Use the directory name (replace all "/" with
# "_") and PID as part of the filename to guarentee uniqueness.

  DIR_NAME=`echo ${DIRECTORY} | tr "/" "_"` 
  CPIO_LIST_FILENAME=${REPL_DIR}CPIO_LIST${DIR_NAME}.$$
  REMOVE_LIST_FILENAME=${REPL_DIR}REMOVE_LIST${DIR_NAME}.$$
  `touch ${CPIO_LIST_FILENAME}`
  CPIO_FILENAME=${REPL_DIR}CPIO${DIR_NAME}.$$
  CLIENT_FILE_LIST=${REPL_DIR}client_file_list.${TO_NODE}${DIR_NAME}.$$
  SERVER_FILE_LIST=${REPL_DIR}server_file_list.${TO_NODE}${DIR_NAME}.$$
  CLIENT_SHORT_LIST=${REPL_DIR}client_list.${TO_NODE}${DIR_NAME}.$$
  SERVER_SHORT_LIST=${REPL_DIR}server_list.${TO_NODE}${DIR_NAME}.$$

# Get the long listing of the directory to be replicated on the LOCAL 
# system (use -n NOT -l). Ignore the "total" line and the lost+found directory.
# Also ignore "." and ".." Sort the results.
  ls -an ${DIRECTORY} | grep -v  "total [0-9]" | grep -v  "lost+found" | grep -vw core | grep -vw core.gz \ | grep -v " \.$" | grep -v " \..$" | sort > ${SERVER_FILE_LIST}.sorted

# Get the long listing of the directory to be replicated on the REMOTE 
# system (use -n NOT -l). Ignore the "total" line and the lost+found directory.
# Also ignore "." and ".." Sort the results.
/replication/client_ls-n ${DIRECTORY} ${TO_NODE} | grep -v "lost+found" |  grep -v  "total [0-9]" \     | grep -v " \.$" | grep -v " \..$" | sort > ${CLIENT_FILE_LIST}.sorted

# Compare the two sorted files.  The files in the LOCAL list that are not in the
# REMOTE list need to be copied to the remote system
  comm -23 ${SERVER_FILE_LIST}.sorted ${CLIENT_FILE_LIST}.sorted > \  ${CPIO_LIST_FILENAME}.long

# Convert the list of LOCAL files that need to be sent to the remote machine
# to just have filenames.

  awk '{print $9}' ${CPIO_LIST_FILENAME}.long > ${CPIO_LIST_FILENAME}

  rm -f ${CPIO_LIST_FILENAME}.long

# Convert the LOCAL list to just have filenames.  This saves us from having
# to do another ls.
  
  awk '{print $9}' ${CPIO_LIST_FILENAME}.long > ${CPIO_LIST_FILENAME}

  rm -f ${SERVER_FILE_LIST}.sorted
  rm -f ${SERVER_FILE_LIST}

# Sort the list of files from the remote machine.
  sort ${SERVER_SHORT_LIST} > ${SERVER_SHORT_LIST}.sorted

# Convert the REMOTE list to just have filenames.  This saves us from having
# to do another ls across the network.  
  
  awk '{print $9}' ${CPIO_LIST_FILENAME}.long > ${CPIO_LIST_FILENAME}

# Sort the list of files from the remote machine.
  sort ${CLIENT_SHORT_LIST} > ${CLIENT_SHORT_LIST}.sorted

  rm -f ${CLIENT_FILE_LIST}.sorted
  rm -f ${CLIENT_SHORT_LIST}

  comm -13 ${SERVER_SHORT_LIST}.sorted ${CLIENT_SHORT_LIST}.sorted > \ ${REMOVE_LIST_FILENAME}

  rm -f ${CLIENT_SHORT_LIST}.sorted
  rm -f ${SERVER_SHORT_LIST}.sorted
  rm -f ${SERVER_SHORT_LIST}

  cd ${DIRECTORY}

# If there are files to be copied to the remote machine then cpio/gzip them up.
  if [ -s ${CPIO_LIST_FILENAME} ]
  then
   cat ${CPIO_LIST_FILENAME} | cpio -ovc | /usr/local/bin/gzip > ${CPIO_FILENAME}
  fi

############################################################################
##  Log the files that are going to be copied to the remote machine and the 
##  number of files copied.  Also, list the files to be removed from the remote
##  and the number of files removed
############################################################################

  echo The following files will be copied: >> ${LOG_FILE}
  `cat ${CPIO_LIST_FILENAME} >> ${LOG_FILE}`

  COPY_FILE_COUNT=`cat ${CPIO_LIST_FILENAME} | wc -l`
  echo ${COPY_FILE_COUNT} files will be sent to ${TO_NODE}. >> ${LOG_FILE}

  echo The following files will be removed: >> ${LOG_FILE}
  `cat ${REMOVE_LIST_FILENAME} >> ${LOG_FILE}`

  REMOVE_FILE_COUNT=`cat ${REMOVE_LIST_FILENAME} | wc -l`
  echo ${REMOVE_FILE_COUNT} files will be removed on ${TO_NODE}. >> ${LOG_FILE}

  rm -f ${CPIO_LIST_FILENAME}

  if [ -s ${CPIO_FILENAME} ]	# If there are files to copy
  then				# then send them to the remote machine
    ftp -n  ${TO_NODE}  >> ${LOG_FILE} <<  EOL
user ${TO_ID} ${TO_PASSWD}
bin
put ${CPIO_FILENAME}
quit
EOL

#  Check if the file was FTPd OK
    FTP_TEST=`/replication/check_ftp ${CPIO_FILENAME} ${TO_NODE}` 

    if [ ${FTP_TEST} -ne 0 ] 
    then # If the file was NOT FTPd OK then log the error and continue
      echo `date`: Files were not copied for ${DIRECTORY} due to an FTP error. >> ${LOG_FILE}
      echo ${COPY_FTP_ERROR}| mailx -s "`uname` Replication Error."  root
      rm -f ${CPIO_FILENAME}
    fi # end of If FTP ERROR
  else # Else there were no files to be copied so cleanup the empty file
    rm -f ${CPIO_FILENAME}
  fi # end of If CPIO file exists and greater then 0

  if [ -s ${REMOVE_LIST_FILENAME} ]
  then # If there are files to remove then send them to the remote machine
    ftp -n  ${TO_NODE}  >> ${LOG_FILE} <<  EOL
user ${TO_ID} ${TO_PASSWD}
bin
put ${REMOVE_LIST_FILENAME}
quit
EOL

#  Check if the file was FTPd OK
    FTP_TEST=`/replication/check_ftp ${REMOVE_LIST_FILENAME} ${TO_NODE}` 
    if [ ${FTP_TEST} -ne 0 ]
    then # If the file was NOT FTPd OK then log the error and continue
      echo `date`: Files were not removed from ${DIRECTORY} due to an FTP error. >> ${LOG_FILE}
      echo ${REMOVE_FTP_ERROR}| mailx -s "`uname` Replication Error."  root 
      rm -f ${REMOVE_LIST_FILENAME}
    fi # end of If FTP ERROR
  else # Else there were no files to be copied so cleanup the empty file
    rm -f ${REMOVE_LIST_FILENAME}
  fi # end of If there are files to remove

  if [ ${COPY_FILE_COUNT} -ne 0 -o ${REMOVE_FILE_COUNT} -ne 0 ]
  then # If files were sent to be copied/removed then process them 
    /replication/process_cpio_file ${CPIO_FILENAME} ${DIRECTORY} \ ${REMOVE_LIST_FILENAME} ${TO_NODE} ${LIST_OF_DIRECTORIES} > /dev/null 2>&1 &
  fi

echo >> ${LOG_FILE}
done   # end of FOR each directory loop. Get the next directory to be replicated

echo >> ${LOG_FILE}

exit
 /=                                                                  )  )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 u   
  S  U            R        )  s            .  G  R  i  x      U      +  j    	  	  l	  	  	  	  	  :
  C
  F
  G
  r
  s
   !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !            -s
  
  
      >  @  o        >      
  X
  
  
  C        h      Y        ?  @             ;  B              B  C   !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !            -C  p        2  z      J  K              [    7  8           m              ?  S  V              I  J         !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !            -  	  
  <  v  w            <  `  }  ~          
  \  a  b      L  p        %   &   \            !  !  M!  !  !  !  !  !  ("  W"   !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !            -W"  r"  v"  "  "  "  "  "  "  "  #  _#  #  $  $$  A$  $  $  $  $  $  J%  y%  %  %  %  %  %  %  %  )&  F&  &  &  :'  ^'  {'  '  '  (  (  R(  (  &)  +)  ,)   !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !            -,)  @)  )  )  )  )  )   !  !  !  !  !  !                                                                                                                                                                                                                                                                                                                                                                                                                                                             K        @  Normal     a	                   " A@ " Default Paragraph Font               &   )                     o    a  )#  &    ;    H                   )      s
  C    W"  ,)  )               	   k                        (  5  7  U  f  `  f  k  q      i  v  x                ;  @  U  l              C  E  G  V  X  Z  g  j              5  =  o    G	  I	  K	  M	  	  	  	  	  4
  6
  J
  N
  
  
  	    7  9  j  l      y  ~  
  
  
  
  
  
      ,  5  E  S  c  e  P  b          %  2          '  +  @  D  J  T  X  \  ^  `  h  l  n  p  q  x  }        E  O                                      O  Q  X  [                  y  {              >  @  b  d              )  -  /  2  6  9  D  H  ^  `  (  <  U  W    +  F  H                    7   ;               
!  !  (!  *!  !  !  !  !  "  "  "  #  ?#  A#  e#  i#  
$  $  $  $  @$  B$  b$  d$  $  $  $  $  -%  /%  K%  M%  %  %  &  &  (&  *&  &                                                                                                                                                                                                                                                             q EDS Technical SupportC:\MCJIM\CODE\REPLIC~1.SHPreferred Customer+C:\MCJIM\Article\CODE\replication_server.sh@Laser2 LPT1: HPPCL Laser2 Laser2                            @ g           ,  ,                                                                                 @ MSUDHP LaserJet Series II                         d 
   Laser2                            @ g           ,  ,                                                                                 @ MSUDHP LaserJet Series II                         d 
                   1   Times New Roman  Symbol &  Arial "  A    h    &                 D                      $    >       EDS Technical SupportEDS Technical Support                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	   
         
                                                             !   &   .   R o o t   E n t r y         H  I  {                 	           F    `^`8`%     ;  W o r d D o c u m e n t           "   Q   R                   !  !  !  !  !  !  !  !  8"      B  "   C o m p O b j     #  $  $  >$  $  $  $  $  $  $  $   %  ,&  y&  &  &                      j   e(   S u m m a r y I n f o r m a t i o n   (  (  (  (  (  (  (    (  (  (  !  !                                            	         
    
   	           F   Microsoft Word Document 
   MSWordDoc    Word.Document.6 9q                                                         Oh +'0                                                       	   $     0  
   X     d     p  
   |                                                     EDS Technical Support                     @       Normal.dot \      EDS Technical Support        4         Microsoft Word for Windo D o c u m e n t S u m m a r y I n f o r m a t i o n           8                                      
                                                                                                                                                                                                                                                                                                                                                                                             ՜. +,0            H      P      t      |                                      Dell Computer Corporation @          D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ws 95 F @       @           @    ~r;Ҭ@    '`                                                                                      ՜. +,0            H      P      t      |                                      Dell Computer Corporation @          D                                                                                                                                                                                                     