#!/usr/bin/perl
#
# ----- IDENTIFICATION SECTION ----------------------------------------------
#
# MODULE:	passwdexp.pl
# AUTHOR:	Chris Hare
# PROJECT: 	UNIX Auditing Tools
# COPYRIGHT:	(C) 2001, Chris Hare.  All Rights Reserved
#
# ----- DESCRIPTION ---------------------------------------------------------
# Thsi program prints the expiration and password change information for a user's
# account.  This information includes
#	user name
#	date of last password change
#	when can the user change their password again
#	When must the user change their password
# ---------------------------------------------------------------------------
#
# This version ONLY tests /etc/shadow. so make sure it exists and is readable by the user executing this 
# program
#
if ( ! -r "/etc/shadow" )
   {
   printf STDERR "error:  /etc/shadow either does not exist or is not readable %s\n", $!;
   exit(1);
   }
#
# Print the report headings
#
printf STDOUT "Last Password Change\n";
printf STDOUT "%-15s  %-15s  %-15s  %-15s\n", "Username", "Last Changed on", "Can Change", "Must Change";
#
# Now, open /etc/shadow
#
open SHADOW, "/etc/shadow";
#
# While there is data to read, process it 
#
while (<SHADOW>)
   {
   #
   # drop that newline!
   #
   chop;
   #
   # split the shadow file entry into its components
   #
   #	pw_name 	-	user name
   #	pw_passwd	-	encrypted password
   #	last_change	-	days since last password counted as days since Jan 1, 1970
   #	can_change	-	days before the user can change their password
   #	must_change	-	days when the user must change their password (expiration)
   #	days_to_expire	-	days before expiration when expiration notices are given
   #	grace		-	time after expiration when user can login after they change their password
   #	days_disabled	-	number of days since Jan 1, 1970 when the password expired
   #	reserved	-	reserved
   #
   ( $pw_name, $pw_passwd, $last_change, 
     $can_change, $must_change, $days_to_expire, $grace, 
     $days_disabled, $reserved ) = split(/:/, $_ );
   #
   # if the length of the password is less than 13, it can't be either a DES or MD5 password!
   #
   if ( length( $pw_passwd ) >= 13 )
      {
      #
      # set the values to something human readable
      #
      $can_change = "Now" if ( $can_change == 0 );
      $must_change = "Never" if ( $must_change == 99999 );
      #
      # determine the date of expiration if it is set
      #
      if ( $must_change < 99999 && $must_change ne "Never")
         {
         $must_change = $last_change + $must_change;
         ( $sec, $min, $hour, $mday, 
           $mon, $year, $wday, $yday, $isdst ) = localtime( $must_change * 86400 );
         $dayName = (Sun,Mon,Tue,Wed,Thu,Fri,Sat)[$wday];
         $monthName = (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[$mon];
         $must_change = sprintf( "%s %s %0d %d", $dayName, $monthName, $mday, $year + 1900);
	 }
      #
      # When was the password last changed?
      #
      ( $sec, $min, $hour, $mday, 
        $mon, $year, $wday, $yday, $isdst ) = localtime( $last_change * 86400 );
      $dayName = (Sun,Mon,Tue,Wed,Thu,Fri,Sat)[$wday];
      $monthName = (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)[$mon];
      $last_change = sprintf( "%s %s %0d %d", $dayName, $monthName, $mday, $year + 1900);
      #
      # print the information
      #
      printf STDOUT "%-15s  %-15s  %-15s  %-15s\n", $pw_name, $last_change, $can_change, $must_change;
      }
   }

# 
# That's all folks!
#
