#!/bin/perl

#######################################################
#                                                     
#  Perl notification script called by fault_manager.pl       
#                   
#  Uses configuration file notify.conf                                  
#                                                     
#  Parameters passed by alerter:                      
#    $ARGV[0] -> Host                                 
#    $ARGV[1] -> Event Class                          
#    $ARGV[2] -> Event Instance                       
#    $ARGV[3] -> Severity                             
#    $ARGV[4] -> Msg                                  
#    others are passed but not used                   
#                                                     
#######################################################
#
# The configuration file is made up of four sections
#
# The first section is the host section

setGlobals();

getConfigFile();

buildHostSearch();

buildMappings();

performEliminations();

create_problem_record();

perform_notifications();

sub setGlobals() {
     # Assign command-line parameters to variables
     $Host=$ARGV[0];
     $Event_Class=$ARGV[1];
     $Event_Instance=$ARGV[2];
     $Severity=$ARGV[3];
     $Msg=$ARGV[4];
     
     # Location of config file
     $config='/opt/bin/alert/notify.conf';
     
     # Location of log file
     $log='/tmp/notify.log';
	
     # Constants to improve readability of array subscripting
	
     # Notification Mapping Array
     $_Group_Name=0;
     $_Host=1;
     $_Event_Class=2;
     $_Event_Instance=3;
     $_Primary=4;
     $_Notify=5;
     
     # Notification Group Array
     $_Pager_Modem=1;
     $_Pager_Number=2;
     $_Pager_Code=3;
     $_Infoman_Class=4;
     
     # Host SLA Array
     $_SLA_Name=0;
     $_SLA_Start_Hour=1;
     $_SLA_End_Hour=2;
     $_SLA_Weekend=3;
}

sub getConfigFile() {
     # Read in the config file into appropriate 2-dimensional arrays
     #    @Host_SLA
     #    @Host_Groups
     #    @Notification_Groups
     #    @Mappings 
     
     # Open log file to start script's logging
     open(LOG, ">> $log") or warn "Couldn't open $log: $!\n";
     print LOG "\n";
     print LOG localtime(time())."\n";
     print LOG $#ARGV;
     print LOG @ARGV;
     print LOG "\n";
     
     open(CONF, "< $config") or warn "Cannot open $config: $!\n";
     @newlines=<CONF>;
     
     # Strip out comment lines, spaces and blank lines
     foreach $line (@newlines) {
     	$line=~ s/#.*//;
     	$line=~ s/ //; 
     	if (not $line eq "\n") {
     		push @lines, $line; }
     }
     
     # Create the array of Host Groups
     @Temp_Host_Groups = grep /Host_Group:/, @lines;
     foreach $Host_Group (@Temp_Host_Groups) {
        @temp=split /:/, $Host_Group;
        shift @temp;
        @items=split /,/, $temp[0];
        push @Host_Groups, [@items]; }
     
     # Create the array of Notification Groups
     @Temp_Notification_Groups = grep /Notification_Group:/, @lines;
     foreach $Notification_Group (@Temp_Notification_Groups) {
        @temp=split /:/, $Notification_Group;
        shift @temp;
        @items=split /,/, $temp[0];
        push @Notification_Groups, [@items]; }
     
     # Create the array of Notification Mappings
     @Temp_Mappings = grep /Mapping:/, @lines; 
     foreach $Mapping (@Temp_Mappings) {
        @temp=split /:/, $Mapping;
        shift @temp;
        @items=split /,/, $temp[0];
        push @Mappings, [@items]; }
}

sub buildHostSearch() {
     # Search for host in @Host_Groups and build @Host_Search_Array
     push @Host_Search_Array, $Host;
     for $i (0 .. $#Host_Groups) {
        for $j (1 .. $#{$Host_Groups[$i]}) {
     	chomp $Host_Groups[$i][$j];
     	if ($Host_Groups[$i][$j] eq $Host) {
     		push @Host_Search_Array, $Host_Groups[$i][0];
     	}
        }
     }
}

sub buildMappings() {
     # Loop through @Mappings and build potential mapping list
     # Check host is in Host_Search_Array AND
     # Event Class and Event Instance match
      
     for $i (0 .. $#Mappings) {
        # The wildcard for the host is checked independantly to prevent multiple matches
        # that would result from using eq $Host_Search_Array or eq *
        if ($Mappings[$i][$_Host] eq '*') {
     	if (($Mappings[$i][$_Event_Class] eq $Event_Class) or ($Mappings[$i][$_Event_Class] eq '*')) {
                      if (($Mappings[$i][$_Event_Instance] eq $Event_Instance) or ($Mappings[$i][$_Event_Instance] eq '*')) {
                             push @Pot_Mappings, $Mappings[$i];
                       }
             } 
        } else {
        	for $x (0 .. $#Host_Search_Array) {
     		if ($Mappings[$i][$_Host] eq $Host_Search_Array[$x]) {
     			if (($Mappings[$i][$_Event_Class] eq $Event_Class) or ($Mappings[$i][$_Event_Class] eq '*')) {
     				if (($Mappings[$i][$_Event_Instance] eq $Event_Instance) or ($Mappings[$i][$_Event_Instance] eq '*')) {
     					$Mappings[$i][$_Host]=$Host_Search_Array[0];
     					push @Pot_Mappings, $Mappings[$i];
     				}
     			}
     		}
        	}
        }
     }
}

sub performEliminations() {
     # Begin elimations
     
     # Screen out the wildcards except those that request notification
     # Create a new array including only those that should be notified
     
     $lines=$#Pot_Mappings;
     $i=0;
     while ($i <= $lines) {
     	if ($Pot_Mappings[$i][$_Notify] eq "Y") {
     		push @Notification, @{Pot_Mappings[$i]};
     		splice @Pot_Mappings, $i, 1;
     		$lines--;
     	} else {
     		$i++;
     	}
     }
     
     
     # Event Instance exact match vs. *
     
     $lines=$#Pot_Mappings;
     $i=0;
     while ($i < $lines) {
     	$z=$i+1;
     	while ($z <= $lines) {
     		if (($Pot_Mappings[$i][$_Event_Instance] eq '*') and ($Pot_Mappings[$z][$_Event_Instance] eq $Event_Instance)) {
     			# The line being checked is the least specific and will be deleted 
     			splice @Pot_Mappings, $i, 1;
     			$lines--;
     			$i--;
     			last;
     		} elsif (($Pot_Mappings[$i][$_Event_Instance] eq $Event_Instance) and ($Pot_Mappings[$z][$_Event_Instance] eq '*')) {
     			splice @Pot_Mappings, $z, 1;
     			$lines--;
     			$z--;
     		}
     		$z++;
     	}
     	$i++;
     }	
     
     
     # Event_Class exact match vs. *
     
     $lines=$#Pot_Mappings;
     $i=0;
     while ($i < $lines) {
             $z=$i+1;
             while ($z <= $lines) {
                     if (($Pot_Mappings[$i][$_Event_Class] eq '*') and ($Pot_Mappings[$z][$_Event_Class] eq $Event_Class)) {
                             # The line being checked is the least specific and will be deleted
                             splice @Pot_Mappings, $i, 1;
                             $lines--;
                             $i--;
                             last;
                     } elsif (($Pot_Mappings[$i][$_Event_Class] eq $Event_Class) and ($Pot_Mappings[$z][$_Event_Class] eq '*')) {
                             splice @Pot_Mappings, $z, 1;
                             $lines--;
                             $z--;
                     }
                     $z++;
             }
             $i++;
     }
     
     
     # Host Name exact match vs. *
     
     $lines=$#Pot_Mappings;
     $i=0;
     while ($i < $lines) {
             $z=$i+1;
             while ($z <= $lines) {
                     if (($Pot_Mappings[$i][$_Host] eq '*') and ($Pot_Mappings[$z][$_Host] eq $Host)) {
                             # The line being checked is the least specific and will be deleted
                             splice @Pot_Mappings, $i, 1;
                             $lines--;
                             $i--;
                             last;
                     } elsif (($Pot_Mappings[$i][$_Host] eq $Host) and ($Pot_Mappings[$z][$_Host] eq '*')) {
                             splice @Pot_Mappings, $z, 1;
                             $lines--;
                             $z--;
                     }
                     $z++;
             }
             $i++;
     }
     
     
     # Add whats left in @Pot_Mappings to @Notification
     for $i (0 .. $#Pot_Mappings) {
     	push @Notification, $Pot_Mappings[$i];
     }
} 

sub create_problem_record {
	# This routine will have to be custom coded to the specific problem managment 
	# system at your site.
	#
	# Almost all problem management systems provide some sort of API to permit
	# programic creation of problem tickets.
	#
	# We have written integration with Peregrine ServiceCentre using their
	# SCAutomate Software Developement Kit (SDK)
	#
	# We have written integration scripts to Remedy ARS
	# using the ARSPerl libraries available from http://arsinfo.cit.buffalo.edu/perl/
	#
	# We have also written to the mainframe system INFOMAN
	# for a site using a MVS batch API and submitting the batch job through FTP to the
	# JES system.
	#
	# Anything is possible.

}

sub perform_notifications() {
     # Loop through remaining matches and implement notifications
     for $i (0 .. $#Notification) {
     	if ($Severity ne "FATAL") {
     		email($Notification[$i][$_Group_Name]);
     		print LOG ("Emailing $Notification[$i][$_Group_Name]\n");
     		email("ServDesk");
     		print LOG ("Emailing Service Desk\n");
     	} else {
               email($Notification[$i][$_Group_Name]);
               print LOG ("Emailing $Notification[$i][$_Group_Name]\n");
               page($Notification[$i][$_Group_Name]);
               print LOG ("Paging $Notification[$i][$_Group_Name]\n");
     	}
     }
}

# Subroutine to page
sub page {
	my $Group_Name = $_[0];
	my $msg = "$Host: $Event_Class alert on $Event_Instance";
	$return=system("/opt/bin/qpage -p $Group_Name $msg");
}

sub email {
	# Subroutine to email - make sure path to your sendmail is correct!
	my $Group_Name = $_[0];
	my $msg="\"$Msg\"";
	my $to="$Group_Name";
	my $subject="$Host: $Event_Class alert on $Event_Instance";
	open(SENDMAIL, "|/usr/lib/sendmail -oi -t")
		or warn "Cannot fork for sendmail: $!\n";
print SENDMAIL <<"EOF";
From: T/EC
To: $to
Subject: $subject
$msg
EOF
	close(SENDMAIL) or warn "Sendmail didn't close nicely";	
}